/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nhindirect.stagent.mail.Message;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Header;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;


import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.nhindirect.common.mail.MDNStandard;

import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;
/**
 * 
 * @author Elan Jaffee
 */
public class SendMail {
	private static final Log LOGGER = LogFactory.getFactory().getInstance(
			SendMail.class);

	public static void sendMessage(ArrayList<MailAddress> recipients,
			String sender, String attachments, String subject, String body,
			String html, long time, long size, String headers, byte[] message,
			String message_id, String to, String cc, String bcc,int priority,String mailtype,
			AddressCheck lefttosend, boolean request_dispatched) {

		Map<String, String> properties = MailetProperties.getPropertiesList();
		// Database connection information
        String db_hostname = properties.get("mailet.db.hostname");
		String db_port  = properties.get("mailet.db.port");
		String db_name  = properties.get("mailet.db.mailname");
		String db_instance  = properties.get("mailet.db.instance");
		String db_userid = properties.get("mailet.db.mailusername");
		String product = properties.get("productname");
		String db_password = properties
				.get("mailet.db.mailpassword");
		String folder_path = properties
				.get("mailet.error.folder");
		String aes = properties.get("mailet.error.aes");
                String domainsProperty = properties.get("mailet.domain");
                String[] domainsList = domainsProperty.split(",");
                
		Connection conn = null;
		try {
			try {
				conn = databaseConnect(db_hostname, db_port, db_name,
						db_instance, db_userid, db_password);
			} catch (SQLException e) {
				LOGGER.trace("Failed to connect to SQL Server");
			}
                        //create query for inserting mail into the database
			String sqlQuery = "INSERT INTO messages ([recipients], [sender], [mailbox_id] ,[attachments], [subject], [plain],[html],[timestamp], [folder_id], [size], [flags],[headers] ,[raw_mime],  [message_id],  [seen], [draft], [sent],[archived],[to],[cc],[bcc],[priority],[mailtype]) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?,?,?,?,?,?)";
			PreparedStatement prepQuery = null;
			try {
				if (conn != null) {
					prepQuery = conn.prepareStatement(sqlQuery,
							Statement.RETURN_GENERATED_KEYS);
				}
				if (prepQuery != null) {
					if (recipients != null) {
                                                //turn recipeitns into JSON array
                                                JSONArray rjson = new JSONArray();
                                                Iterator<MailAddress> riterator = recipients.iterator();
                                                while(riterator.hasNext()){                                         
                                                    rjson.add(riterator.next().toString()); 
                                                }
						prepQuery.setString(1, rjson.toJSONString());
					} else {
						prepQuery.setString(1, null);
					}
					prepQuery.setString(2, sender);
					prepQuery.setString(4, attachments);
					prepQuery.setString(5, subject);
					prepQuery.setString(6, body);
					prepQuery.setString(7, html);

					prepQuery.setLong(8, time);

					prepQuery.setString(9, null);
					prepQuery.setLong(10, size);
					prepQuery.setString(11, null);
					prepQuery.setString(12, headers);
					prepQuery.setString(13, new String(message));
					prepQuery.setString(14, message_id);
					prepQuery.setInt(15, 0);
					prepQuery.setInt(16, 0);
					prepQuery.setInt(17, 0);
					prepQuery.setInt(18, 0);
					prepQuery.setString(19, to);
					prepQuery.setString(20, cc);
					prepQuery.setString(21, bcc);
					prepQuery.setInt(22, priority);
					prepQuery.setString(23, mailtype);
					
					if (lefttosend == null) {
                                                //get all of the local for the message that are local
						lefttosend = new AddressCheck(recipients, domainsList);
					}
                                        //get if there was any AutoReply messages
                                        AutoReply ar = new AutoReply(lefttosend.getMailbox().values(),sender.toLowerCase());
                                        
					if (!lefttosend.getFailed()) {//will only fail if AddressCheck could not connect to database and get data
						HashMap<MailAddress,Integer> mailboxes = new HashMap<MailAddress,Integer>(lefttosend.getMailbox());
                                                
                                                //find out if the sender is local
                                                int atPosition = sender.indexOf("@") + 1;
                                                String currentdomain = sender.substring(atPosition);
						boolean isLocal = Arrays.asList(domainsList).contains(currentdomain);
                                                
                                                //iterate through each mailbox and send the message
						for(Map.Entry<MailAddress, Integer> mailbox: mailboxes.entrySet()){
							prepQuery.setInt(3, mailbox.getValue());
							if (prepQuery.executeUpdate() == 0) {//if it fails to save message store message
								localStore(recipients, sender, attachments,
										subject, body, html, time, size,
										headers, message, message_id,
										folder_path, to, cc, bcc, priority, mailtype, aes,
										lefttosend, request_dispatched);

								return;
							} else {
                                                            //when message succesfully is stored
                                                            try {
                                                                //Auto reply messages  
                                                                String autoMessage = ar.getMessage(mailbox.getValue());//get message for this mailbox
                                                                if(autoMessage != null){  //check if message exists
                                                                    //create mime for auto reply
                                                                    MimeMessage mime = createAutoResponseMessage(sender, mailbox.getKey(), subject, autoMessage);
                                                                    Message msg = new Message(mime);
                                                                    //mark message as created (prevent infinite loops is sending locally so needs to be first before actually storing message
                                                                    ar.messageSent(mailbox.getValue());
                                                                    if(isLocal){
                                                                        //turn recipiets to array
                                                                        ArrayList<MailAddress>  autoRecipient = new ArrayList<MailAddress>();
                                                                        autoRecipient.add(new MailAddress(sender));
                                                                        //get all headers
                                                                        Enumeration autoHeadersEm = msg.getAllHeaders();
                                                                        JSONObject autoHeaders = new JSONObject();
                                                                        while(autoHeadersEm.hasMoreElements()){
                                                                            Header head = (Header) autoHeadersEm.nextElement();
                                                                            autoHeaders.put(head.getName(), head.getValue());
                                                                        }
                                                                        //mime to bytes
                                                                        byte[] serizalizedMime = StoreMail.serialize(mime);
                                                                        
                                                                        //get plain text from html
                                                                        HtmlParser autoText = new HtmlParser();
                                                                        try{
                                                                             autoText = new HtmlParser(autoMessage);
                                                  
                                                                        }catch (IOException ex) {
                                                                            Logger.getLogger(SendMail.class.getName()).log(Level.WARNING, "Unable to parse html to text in autoreply", ex);
                                                                            autoText.handleText(autoMessage.toCharArray(), 0);//if failes to parse just add html
                                                                        }
                                                                        //send auto reply localy as if it was a message
                                                                        sendMessage(autoRecipient ,mailbox.getKey().toString(),"", mime.getSubject() ,  autoText.getText() , autoMessage, System.currentTimeMillis() / 1000L,  serizalizedMime.length,  autoHeaders.toJSONString(), serizalizedMime, msg.getMessageID(),  sender,  "",  "", 3, "html", null, false) ;                                                         
                                                                    }
                                                                    else{
                                                                        //send message externally
                                                                        Transport.send(msg);
                                                                    }
                                                                    
                                                                }
                                                            } catch (MessagingException ex) {
                                                                Logger.getLogger(SendMail.class.getName()).log(Level.SEVERE, "Message exception in auto reply", ex);
                                                            } catch (IOException ex) {
                                                                Logger.getLogger(SendMail.class.getName()).log(Level.SEVERE, "IO exception in auto reply", ex);
                                                            }
                                                            if(request_dispatched){
                                                                if(isLocal){
                                                                        //mark message as dispatched in database for local mail
									LogMessage.setMessageStatus(message_id, mailbox.getKey().toString(), 5, new Date().getTime()/ 1000L);
								}
								else{
                                                                        //send mdn externally
									send_mdn(sender, NotificationType.Dispatched , mailbox.getKey().toString() , message_id, mailbox.getKey().getDomain(),  product, subject, "Your message was successfully delivered");
								}
                                                            } 
                                                                //remove send address so that if message fails then it will not send it to the same use again
								lefttosend.removeAddress(mailbox.getKey());
                                                                ResultSet rs = null;
                                                                //get id on new message
                                                                int genKey = -1;
                                                                try {
                                                                    rs = prepQuery.getGeneratedKeys();
                                                                    if (rs.next()) {
                                                                        genKey = rs.getInt(1);
                                                                    }
                                                                } finally {
                                                                    if (rs != null) {
                                                                        rs.close();
                                                                    }
                                                                }
                                                                if(genKey > 0){
                                                                   JSONObject apiData= new JSONObject();
                                                                   apiData.put("mailbox", mailbox.getKey().getUser());
                                                                   apiData.put("id", genKey);
                                                                   
                                                                   if(!DirectAPI.post( "/direct/messages/process_incoming", apiData, "Message was successfully processed.")){
                                                                       LOGGER.error("Direct api did not return the expected result for process_incoming");
                                                                   }
                                                                }
							}
						}
						
					} else {//left to send failed
						localStore(recipients, sender, attachments, subject,
								body, html, time, size, headers, message,
								message_id, folder_path, to, cc, bcc, priority, mailtype, aes,
								null, request_dispatched);
					}

				} else {
					localStore(recipients, sender, attachments, subject, body,
							html, time, size, headers, message, message_id,
							folder_path, to, cc, bcc,priority, mailtype, aes, lefttosend,request_dispatched);

				}

			} catch (SQLException e) {
				localStore(recipients, sender, attachments, subject, body,
						html, time, size, headers, message, message_id,
                                                folder_path, to, cc, bcc,priority, mailtype, aes, lefttosend,request_dispatched);
			} finally {

				if (prepQuery != null) {
					try {
						prepQuery.close();
					} catch (SQLException e) {
						LOGGER.debug("Did not close prepQuery");
					}
				}
			}
		} finally {
			try {

				if (conn != null) {
					conn.close();
				}

			} catch (SQLException ex) {
				LOGGER.debug("Failed to close connection");
			}
		}
	}
        /*
         * connect to the database
         */
	private static Connection databaseConnect(String db_hostname,
			String db_port, String db_name, String db_instance,
			String db_userid, String db_password) throws SQLException {
		Connection conn = null;
		if (db_hostname == null) {
			return null;
		}
		String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":"
				+ db_port + ";databaseName=" + db_name
				+ ";ssl=require;hostNameInCertificate=" + db_hostname
				+ ";instanceName=" + db_instance + ";portNumber=" + db_port
				+ ";trustServerCertificate=true";

		// Load DB Driver
		try {
			Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
		} catch (ClassNotFoundException f) {
			LOGGER.trace("Could not load SQL Server DB driver");
		}

		// Connect to DB
		try {
			conn = DriverManager.getConnection(db_connect_string, db_userid,
					db_password);
		} catch (SQLException sqlException) {
			LOGGER.trace("SQL Server database not reachable");
			return null;
		}

		return conn;
	}
        /*
         * stores messages encrypted localy is something goes wrong like a database connection issue
         */
	private static void localStore(ArrayList<MailAddress> recipients,
			String sender, String attachments, String subject, String body,
			String html, long time, long size, String headers, byte[] message,
			String message_id, String folder_path, String to, String cc,
			String bcc, int priority, String mailtype, String aes, AddressCheck lefttosend, boolean request_dispatched) {

		SecureRandom random = new SecureRandom();
		//byte key[] = new byte[32];
		byte iv[] = new byte[16];
		byte[] salt = new byte[32];           
                random.nextBytes(salt);
                byte[] key = (sha256(aes)+salt).getBytes();
                key = Arrays.copyOf(key, 32);
		random.nextBytes(iv);
		String path = folder_path + "message" +message_id.hashCode()+ System.currentTimeMillis()
				+ ".ser";
		ArrayList ar = new ArrayList();
		IvParameterSpec IV = new IvParameterSpec(iv);
            
		ar.add(iv);
                ar.add(salt);
		ar.add(recipients);
		ar.add(encrypt_String(sender, key, IV));
		ar.add(encrypt_String(attachments, key, IV));
		ar.add(encrypt_String(subject, key, IV));
		ar.add(encrypt_String(body, key, IV));
		ar.add(encrypt_String(html, key, IV));
		ar.add(encrypt_String("" + time, key, IV));
		// ar.add(encrypt_String(folder, key, IV));
		ar.add(encrypt_String("" + size, key, IV));
		// ar.add(encrypt_String(flags, key, IV));
		ar.add(encrypt_String(headers, key, IV));
		ar.add(encrypt(message, key, IV));
		ar.add(encrypt_String(message_id, key, IV));
		ar.add(encrypt_String(to, key, IV));
		ar.add(encrypt_String(cc, key, IV));
		ar.add(encrypt_String(bcc, key, IV));
		ar.add(encrypt_String(""+ priority, key, IV));
		ar.add(encrypt_String(mailtype, key, IV));
                ar.add(encrypt_String((request_dispatched?"true":"false"),key,IV));
		ar.add(lefttosend);
		SendErrors.lock();
		ObjectOutputStream oos;
		FileOutputStream fos = null;

		try {
                        URL url= new URL("file:"+path);
                        File file;
                    try {
                        //file = new File(url.toURI()); //FileSystems.getDefault().getPath(folder_path).toFile();
                        
                        /*normalizes the file path to mitigate the Path manipulation/hacking vulnerability */
                        file = new File(url.toURI().normalize());
                    } catch (URISyntaxException ex) {
                        LOGGER.error("Path not found");
                        return;
                      }
			fos = new FileOutputStream(file);//FileSystems.getDefault().getPath(path).toFile());
			oos = new ObjectOutputStream(fos);
			oos.writeObject(ar);
			oos.close();
		} catch (FileNotFoundException e) {
			LOGGER.error("File Not Found");
		} catch (IOException e) {
			LOGGER.error("IOException in local store");
		} finally {
			try {
				if (fos != null) {
					fos.close();
				}
			} catch (IOException ex) {
				LOGGER.debug("failed to close out file");
			}
                        SendErrors.unlock();
		}
		

	}
        /*
         * takes in a plain text sting, a key, and its IV and returns encrypted bytes
         */
	private static byte[] encrypt_String(String plainText,
			byte[] encryptionKey, IvParameterSpec IV) {
		if (plainText == null) {
			return null;
		} else {
			byte[] enc = null;
			try {
				enc = encrypt(plainText.getBytes("UTF-8"), encryptionKey, IV);

			} catch (UnsupportedEncodingException ex) {
				enc = encrypt(plainText.getBytes(), encryptionKey, IV);

			}
			return enc;
		}
	}
         /*
         * takes in a plain bytes sting, a key, and its IV and returns encrypted bytes
         */
	private static byte[] encrypt(byte[] plainText, byte[] encryptionKey,
			IvParameterSpec IV) {
		Cipher cipher = null;
		try {
			cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
		} catch (NoSuchAlgorithmException ex) {
			LOGGER.error("No such algorithm exception while encrypting");
		} catch (NoSuchProviderException ex) {
			LOGGER.error("No such provider exception while encrypting");
		} catch (NoSuchPaddingException ex) {
			LOGGER.error("No such padding exception while encrypting");
		}
		SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
		try {
			if (cipher == null) {
				return null;
			}
			cipher.init(Cipher.ENCRYPT_MODE, key, IV);
		} catch (InvalidKeyException ex) {
			LOGGER.error("Invalid key exception while encrypting");
		} catch (InvalidAlgorithmParameterException ex) {
			LOGGER.error("Invalid algorithm paranerter exception while encrypting");
		}
		try {
			return cipher.doFinal(plainText);
		} catch (IllegalBlockSizeException ex) {
			LOGGER.error("Illegal block size exception while encrypting");
		} catch (BadPaddingException ex) {
			LOGGER.error("Bad padding exception while encrypting");
		}
		return null;
	}
        /*
         * check to ensure email address is valid
         * NOTE: currently not used
         */
	public static boolean isValidEmailAddress(String email) {
		if (email.contains("*")) {// no wild cards allowed
			return false;
		}
		boolean result = true;
		try {
			InternetAddress emailAddr = new InternetAddress(email);
			emailAddr.validate();
		} catch (AddressException ex) {
			result = false;
		}
		return result;
	}

        /*
         * converts sting to sha256 string.  used for encryption
         */
        private static String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();

            for (int i = 0; i < hash.length; i++) {
                String hex = Integer.toHexString(0xff & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }

            return hexString.toString();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
        
        /*
         * this funtion creates and sends any type of MDN.  
         */
    private static void send_mdn(String to, NotificationType disposition, String from, String original_message_id, String domain, String product, String subject, String message) {
        try{
        Disposition disp = new Disposition(disposition);        
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        message = "Your message: \r\n"+
                "    From.....: "+to+" \r\n"+
                "    Subject..: "+StringEscapeUtils.escapeHtml(subject)+" \r\n"+
                message + " on "+ new Date();
        MimeMultipartReport multiPart = new MimeMultipartReport();
        multiPart.setReportType("disposition-notification");  
        Notification not = new Notification(disp);
          not.setOriginalMessageId(original_message_id);
          not.setFinalRecipient(from);
          not.setExtensions(Arrays.asList(MDNStandard.DispositionOption_TimelyAndReliable));
          ReportingUserAgent rua = new ReportingUserAgent(domain, product);
          not.setReportingAgent(rua);
          not.setExplanation(message);
          NotificationMessage msg = new NotificationMessage(to, not);
          msg.setSubject(disposition+": "+StringEscapeUtils.escapeHtml(subject));
          msg.setFrom(new InternetAddress(from));
          Transport.send(msg);
        }catch(MessagingException e){
        	LOGGER.debug("Failed to send out " + disposition + " MDN to " + to);
        }
    }
    
    /*
     * this funtion adds patient info to the patiens table and quarilates it to a message
     * @param conn          Database connection
     * @param message_id    id of message that was stored
     * @param patients      map of patients
     */
    /*
    private static void addPatients(Connection conn, int message_id, HashMap<String,Object> patients){
        String sqlQuery = "INSERT INTO patients (message_id,given_name,family_name,date_of_birth,title,organization,file_hash) VALUES (?,?,?,?,?,?,?)";
	PreparedStatement prepQuery = null;
        try{
            prepQuery = conn.prepareStatement(sqlQuery,Statement.RETURN_GENERATED_KEYS);
            String[] inputs = {"given_name","family_name","date_of_birth","title","organization","file_hash"};
            for(Entry<String,Object> entry:patients.entrySet()){
                HashMap<String, String> patient = (HashMap<String,String>) entry.getValue();
                if(patient != null){
                    prepQuery.clearParameters();
                    prepQuery.setInt(1, message_id);
                    int index = 2;
                    for(String input:inputs){
                        if(patient.containsKey(input)){
                            prepQuery.setString(index,patient.get(input));
                        }
                        else{
                            prepQuery.setString(index,null);
                        }
                        index++;
                    }
                    prepQuery.executeUpdate();
                }
            }
        }   catch (SQLException ex) {
                LOGGER.debug("Could not store patients for "+message_id);
         }
    }
    */
    
    /*
     * This funtion creates a mime for an auto reponse method
     * @param to        The recipient of the auto response
     * @param from      The sender of the auto response
     * @param subject   The subject of the original message
     * @param message   The auto response message
     * @return          Mime containing the auto reply
     */
    protected static MimeMessage createAutoResponseMessage(String to,MailAddress from, String subject, String message){
        MimeMessage mime= new MimeMessage((Session)null);
            try {
                mime.setFrom(from.toInternetAddress());
                mime.addRecipients(javax.mail.Message.RecipientType.TO, to);
                mime.setContent(message,"text/html");
                mime.setSubject("Automatic reply: "+subject);
            } catch (AddressException ex) {
                Logger.getLogger(SendMail.class.getName()).log(Level.SEVERE, null, ex);
            } catch (MessagingException ex) {
                Logger.getLogger(SendMail.class.getName()).log(Level.SEVERE, null, ex);
            }
         return mime;
        
    }
   
}


